package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, short) -> double}.
 *
 */
@FunctionalInterface
public interface DblShortToDbl extends
        net.mintern.functions.binary.checked.DblShortToDblE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblShortToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblShortToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblShortToDblE<E> f) {
        return (d, sh) -> {
            try {
                return f.call(d, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblShortToDbl unchecked(
            net.mintern.functions.binary.checked.DblShortToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblShortToDbl uncheckedIO(
            net.mintern.functions.binary.checked.DblShortToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToDbl
    bind(DblShortToDbl f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToDbl bind(double d) {
        return DblShortToDbl.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> double}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> double} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToDbl
    rbind(DblShortToDbl f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> double} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToDbl rbind(short sh) {
        return DblShortToDbl.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(DblShortToDbl f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(double d, short sh) {
        return DblShortToDbl.bind(this, d, sh);
    }
}
