package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface FloatBoolToShort extends
        net.mintern.functions.binary.checked.FloatBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatBoolToShortE<E> f) {
        return (fl, bool) -> {
            try {
                return f.call(fl, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatBoolToShort unchecked(
            net.mintern.functions.binary.checked.FloatBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(fl, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(FloatBoolToShort f, float fl) {
        return (bool) -> f.call(fl, bool);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(fl, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(float fl) {
        return FloatBoolToShort.bind(this, fl);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatBoolToShort f, boolean bool) {
        return (fl) -> f.call(fl, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(boolean bool) {
        return FloatBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (fl, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatBoolToShort f, float fl, boolean bool) {
        return () -> f.call(fl, bool);
    }

    /**
     * Binds {@code (fl, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, boolean bool) {
        return FloatBoolToShort.bind(this, fl, bool);
    }
}
