package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, char) -> short}.
 *
 */
@FunctionalInterface
public interface FloatCharToShort extends
        net.mintern.functions.binary.checked.FloatCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatCharToShortE<E> f) {
        return (fl, ch) -> {
            try {
                return f.call(fl, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatCharToShort unchecked(
            net.mintern.functions.binary.checked.FloatCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(fl, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(FloatCharToShort f, float fl) {
        return (ch) -> f.call(fl, ch);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(fl, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(float fl) {
        return FloatCharToShort.bind(this, fl);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatCharToShort f, char ch) {
        return (fl) -> f.call(fl, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(char ch) {
        return FloatCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (fl, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatCharToShort f, float fl, char ch) {
        return () -> f.call(fl, ch);
    }

    /**
     * Binds {@code (fl, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, char ch) {
        return FloatCharToShort.bind(this, fl, ch);
    }
}
