package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, int) -> short}.
 *
 */
@FunctionalInterface
public interface FloatIntToShort extends
        net.mintern.functions.binary.checked.FloatIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatIntToShortE<E> f) {
        return (fl, i) -> {
            try {
                return f.call(fl, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatIntToShort unchecked(
            net.mintern.functions.binary.checked.FloatIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(fl, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(FloatIntToShort f, float fl) {
        return (i) -> f.call(fl, i);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(fl, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(float fl) {
        return FloatIntToShort.bind(this, fl);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, i)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatIntToShort f, int i) {
        return (fl) -> f.call(fl, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(int i) {
        return FloatIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (fl, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatIntToShort f, float fl, int i) {
        return () -> f.call(fl, i);
    }

    /**
     * Binds {@code (fl, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, int i) {
        return FloatIntToShort.bind(this, fl, i);
    }
}
