package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, long) -> short}.
 *
 */
@FunctionalInterface
public interface FloatLongToShort extends
        net.mintern.functions.binary.checked.FloatLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatLongToShortE<E> f) {
        return (fl, l) -> {
            try {
                return f.call(fl, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatLongToShort unchecked(
            net.mintern.functions.binary.checked.FloatLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.FloatLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(fl, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(FloatLongToShort f, float fl) {
        return (l) -> f.call(fl, l);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(fl, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(float fl) {
        return FloatLongToShort.bind(this, fl);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, l)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    rbind(FloatLongToShort f, long l) {
        return (fl) -> f.call(fl, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(long l) {
        return FloatLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (fl, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(FloatLongToShort f, float fl, long l) {
        return () -> f.call(fl, l);
    }

    /**
     * Binds {@code (fl, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, long l) {
        return FloatLongToShort.bind(this, fl, l);
    }
}
