package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface FloatObjToShort<U> extends
        net.mintern.functions.binary.checked.FloatObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> FloatObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatObjToShortE<U, E> f) {
        return (fl, u) -> {
            try {
                return f.call(fl, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> FloatObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.FloatObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> FloatObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.FloatObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(fl, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(FloatObjToShort<U> f, float fl) {
        return (u) -> f.call(fl, u);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(fl, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(float fl) {
        return FloatObjToShort.bind(this, fl);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.FloatToShort
    rbind(FloatObjToShort<U> f, U u) {
        return (fl) -> f.call(fl, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort rbind(U u) {
        return FloatObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (fl, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param fl argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(FloatObjToShort<U> f, float fl, U u) {
        return () -> f.call(fl, u);
    }

    /**
     * Binds {@code (fl, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(float fl, U u) {
        return FloatObjToShort.bind(this, fl, u);
    }
}
