package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, short) -> boolean}.
 *
 */
@FunctionalInterface
public interface FloatShortToBool extends
        net.mintern.functions.binary.checked.FloatShortToBoolE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatShortToBoolE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatShortToBool unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatShortToBoolE<E> f) {
        return (fl, sh) -> {
            try {
                return f.call(fl, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatShortToBool unchecked(
            net.mintern.functions.binary.checked.FloatShortToBoolE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatShortToBool uncheckedIO(
            net.mintern.functions.binary.checked.FloatShortToBoolE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToBool
    bind(FloatShortToBool f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToBool bind(float fl) {
        return FloatShortToBool.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> boolean}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> boolean} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToBool
    rbind(FloatShortToBool f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> boolean}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> boolean} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToBool rbind(short sh) {
        return FloatShortToBool.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToBool
    bind(FloatShortToBool f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToBool bind(float fl, short sh) {
        return FloatShortToBool.bind(this, fl, sh);
    }
}
