package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, short) -> char}.
 *
 */
@FunctionalInterface
public interface FloatShortToChar extends
        net.mintern.functions.binary.checked.FloatShortToCharE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatShortToCharE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatShortToChar unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatShortToCharE<E> f) {
        return (fl, sh) -> {
            try {
                return f.call(fl, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatShortToChar unchecked(
            net.mintern.functions.binary.checked.FloatShortToCharE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatShortToChar uncheckedIO(
            net.mintern.functions.binary.checked.FloatShortToCharE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToChar
    bind(FloatShortToChar f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToChar bind(float fl) {
        return FloatShortToChar.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> char}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> char} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToChar
    rbind(FloatShortToChar f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> char} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToChar rbind(short sh) {
        return FloatShortToChar.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToChar
    bind(FloatShortToChar f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToChar bind(float fl, short sh) {
        return FloatShortToChar.bind(this, fl, sh);
    }
}
