package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, short) -> void}.
 *
 */
@FunctionalInterface
public interface FloatShortToNil extends
        net.mintern.functions.binary.checked.FloatShortToNilE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatShortToNilE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> FloatShortToNil unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatShortToNilE<E> f) {
        return (fl, sh) -> {
            try {
                f.call(fl, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> FloatShortToNil unchecked(
            net.mintern.functions.binary.checked.FloatShortToNilE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> FloatShortToNil uncheckedIO(
            net.mintern.functions.binary.checked.FloatShortToNilE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(fl, sh)}.
     */
    static  net.mintern.functions.unary.ShortToNil
    bind(FloatShortToNil f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(fl, sh)}.
     */
    @Override
    default net.mintern.functions.unary.ShortToNil bind(float fl) {
        return FloatShortToNil.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code f.call(fl, sh)}.
     */
    static  net.mintern.functions.unary.FloatToNil
    rbind(FloatShortToNil f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code this.call(fl, sh)}.
     */
    @Override
    default net.mintern.functions.unary.FloatToNil rbind(short sh) {
        return FloatShortToNil.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(fl, sh)}.
     */
    static  net.mintern.functions.nullary.NilToNil
    bind(FloatShortToNil f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(fl, sh)}.
     */
    @Override
    default net.mintern.functions.nullary.NilToNil bind(float fl, short sh) {
        return FloatShortToNil.bind(this, fl, sh);
    }
}
