package net.mintern.functions.binary;

/**
 * An operation of type {@code (float, short) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface FloatShortToObj<R> extends
        net.mintern.functions.binary.checked.FloatShortToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.FloatShortToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> FloatShortToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.FloatShortToObjE<R, E> f) {
        return (fl, sh) -> {
            try {
                return f.call(fl, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> FloatShortToObj<R> unchecked(
            net.mintern.functions.binary.checked.FloatShortToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> FloatShortToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.FloatShortToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    bind(FloatShortToObj<R> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> bind(float fl) {
        return FloatShortToObj.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.FloatToObj<R>
    rbind(FloatShortToObj<R> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToObj<R> rbind(short sh) {
        return FloatShortToObj.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(FloatShortToObj<R> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(float fl, short sh) {
        return FloatShortToObj.bind(this, fl, sh);
    }
}
