package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, double) -> short}.
 *
 */
@FunctionalInterface
public interface IntDblToShort extends
        net.mintern.functions.binary.checked.IntDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntDblToShortE<E> f) {
        return (i, d) -> {
            try {
                return f.call(i, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntDblToShort unchecked(
            net.mintern.functions.binary.checked.IntDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(i, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(IntDblToShort f, int i) {
        return (d) -> f.call(i, d);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(i, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(int i) {
        return IntDblToShort.bind(this, i);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, d)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntDblToShort f, double d) {
        return (i) -> f.call(i, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(double d) {
        return IntDblToShort.rbind(this, d);
    }

    /**
     * Binds {@code (i, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntDblToShort f, int i, double d) {
        return () -> f.call(i, d);
    }

    /**
     * Binds {@code (i, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, double d) {
        return IntDblToShort.bind(this, i, d);
    }
}
