package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, float) -> short}.
 *
 */
@FunctionalInterface
public interface IntFloatToShort extends
        net.mintern.functions.binary.checked.IntFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntFloatToShortE<E> f) {
        return (i, fl) -> {
            try {
                return f.call(i, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntFloatToShort unchecked(
            net.mintern.functions.binary.checked.IntFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(i, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(IntFloatToShort f, int i) {
        return (fl) -> f.call(i, fl);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(i, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(int i) {
        return IntFloatToShort.bind(this, i);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntFloatToShort f, float fl) {
        return (i) -> f.call(i, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(float fl) {
        return IntFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (i, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntFloatToShort f, int i, float fl) {
        return () -> f.call(i, fl);
    }

    /**
     * Binds {@code (i, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i, float fl) {
        return IntFloatToShort.bind(this, i, fl);
    }
}
