package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, int) -> short}.
 *
 */
@FunctionalInterface
public interface IntIntToShort extends
        net.mintern.functions.binary.checked.IntIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntIntToShortE<E> f) {
        return (i1, i2) -> {
            try {
                return f.call(i1, i2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntIntToShort unchecked(
            net.mintern.functions.binary.checked.IntIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.IntIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i1)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param i1 argument 1
     * @return a new function {@code (int i2) -> short} that calls
     *      {@code f.call(i1, i2)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(IntIntToShort f, int i1) {
        return (i2) -> f.call(i1, i2);
    }

    /**
     * Binds {@code (i1)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param i1 argument 1
     * @return a new function {@code (int i2) -> short} that calls
     *      {@code this.call(i1, i2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(int i1) {
        return IntIntToShort.bind(this, i1);
    }

    /**
     * Binds {@code (i2)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param i2 argument 2
     * @return a new function {@code (int i1) -> short} that calls
     *      {@code f.call(i1, i2)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    rbind(IntIntToShort f, int i2) {
        return (i1) -> f.call(i1, i2);
    }

    /**
     * Binds {@code (i2)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param i2 argument 2
     * @return a new function {@code (int i1) -> short} that calls
     *      {@code this.call(i1, i2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort rbind(int i2) {
        return IntIntToShort.rbind(this, i2);
    }

    /**
     * Binds {@code (i1, i2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param i1 argument 1
     * @param i2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i1, i2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(IntIntToShort f, int i1, int i2) {
        return () -> f.call(i1, i2);
    }

    /**
     * Binds {@code (i1, i2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i1 argument 1
     * @param i2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i1, i2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(int i1, int i2) {
        return IntIntToShort.bind(this, i1, i2);
    }
}
