package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, short) -> double}.
 *
 */
@FunctionalInterface
public interface IntShortToDbl extends
        net.mintern.functions.binary.checked.IntShortToDblE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntShortToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntShortToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntShortToDblE<E> f) {
        return (i, sh) -> {
            try {
                return f.call(i, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntShortToDbl unchecked(
            net.mintern.functions.binary.checked.IntShortToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntShortToDbl uncheckedIO(
            net.mintern.functions.binary.checked.IntShortToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToDbl
    bind(IntShortToDbl f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToDbl bind(int i) {
        return IntShortToDbl.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> double}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> double} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToDbl
    rbind(IntShortToDbl f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> double} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToDbl rbind(short sh) {
        return IntShortToDbl.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(IntShortToDbl f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(int i, short sh) {
        return IntShortToDbl.bind(this, i, sh);
    }
}
