package net.mintern.functions.binary;

/**
 * An operation of type {@code (int, short) -> float}.
 *
 */
@FunctionalInterface
public interface IntShortToFloat extends
        net.mintern.functions.binary.checked.IntShortToFloatE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.IntShortToFloatE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntShortToFloat unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.IntShortToFloatE<E> f) {
        return (i, sh) -> {
            try {
                return f.call(i, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntShortToFloat unchecked(
            net.mintern.functions.binary.checked.IntShortToFloatE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntShortToFloat uncheckedIO(
            net.mintern.functions.binary.checked.IntShortToFloatE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToFloat
    bind(IntShortToFloat f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToFloat bind(int i) {
        return IntShortToFloat.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> float}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> float} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToFloat
    rbind(IntShortToFloat f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> float} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToFloat rbind(short sh) {
        return IntShortToFloat.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToFloat
    bind(IntShortToFloat f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToFloat bind(int i, short sh) {
        return IntShortToFloat.bind(this, i, sh);
    }
}
