package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, int) -> short}.
 *
 */
@FunctionalInterface
public interface LongIntToShort extends
        net.mintern.functions.binary.checked.LongIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongIntToShortE<E> f) {
        return (l, i) -> {
            try {
                return f.call(l, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongIntToShort unchecked(
            net.mintern.functions.binary.checked.LongIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.LongIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(l, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(LongIntToShort f, long l) {
        return (i) -> f.call(l, i);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(l, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(long l) {
        return LongIntToShort.bind(this, l);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, i)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    rbind(LongIntToShort f, int i) {
        return (l) -> f.call(l, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort rbind(int i) {
        return LongIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (l, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(LongIntToShort f, long l, int i) {
        return () -> f.call(l, i);
    }

    /**
     * Binds {@code (l, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(long l, int i) {
        return LongIntToShort.bind(this, l, i);
    }
}
