package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface LongObjToShort<U> extends
        net.mintern.functions.binary.checked.LongObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> LongObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongObjToShortE<U, E> f) {
        return (l, u) -> {
            try {
                return f.call(l, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> LongObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.LongObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> LongObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.LongObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(l, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(LongObjToShort<U> f, long l) {
        return (u) -> f.call(l, u);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(l, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(long l) {
        return LongObjToShort.bind(this, l);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.LongToShort
    rbind(LongObjToShort<U> f, U u) {
        return (l) -> f.call(l, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort rbind(U u) {
        return LongObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (l, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param l argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(LongObjToShort<U> f, long l, U u) {
        return () -> f.call(l, u);
    }

    /**
     * Binds {@code (l, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(long l, U u) {
        return LongObjToShort.bind(this, l, u);
    }
}
