package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, boolean) -> short}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjBoolToShort<T> extends
        net.mintern.functions.binary.checked.ObjBoolToShortE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjBoolToShort<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjBoolToShortE<T, E> f) {
        return (t, bool) -> {
            try {
                return f.call(t, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjBoolToShort<T> unchecked(
            net.mintern.functions.binary.checked.ObjBoolToShortE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjBoolToShort<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjBoolToShortE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(t, bool)} and returns the result.
     */
    static <T> net.mintern.functions.unary.BoolToShort
    bind(ObjBoolToShort<T> f, T t) {
        return (bool) -> f.call(t, bool);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(t, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(T t) {
        return ObjBoolToShort.bind(this, t);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, bool)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjBoolToShort<T> f, boolean bool) {
        return (t) -> f.call(t, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(boolean bool) {
        return ObjBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (t, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, bool)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToShort
    bind(ObjBoolToShort<T> f, T t, boolean bool) {
        return () -> f.call(t, bool);
    }

    /**
     * Binds {@code (t, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, boolean bool) {
        return ObjBoolToShort.bind(this, t, bool);
    }
}
