package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, char) -> short}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjCharToShort<T> extends
        net.mintern.functions.binary.checked.ObjCharToShortE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjCharToShort<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjCharToShortE<T, E> f) {
        return (t, ch) -> {
            try {
                return f.call(t, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjCharToShort<T> unchecked(
            net.mintern.functions.binary.checked.ObjCharToShortE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjCharToShort<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjCharToShortE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(t, ch)} and returns the result.
     */
    static <T> net.mintern.functions.unary.CharToShort
    bind(ObjCharToShort<T> f, T t) {
        return (ch) -> f.call(t, ch);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(t, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(T t) {
        return ObjCharToShort.bind(this, t);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, ch)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjCharToShort<T> f, char ch) {
        return (t) -> f.call(t, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(char ch) {
        return ObjCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (t, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, ch)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToShort
    bind(ObjCharToShort<T> f, T t, char ch) {
        return () -> f.call(t, ch);
    }

    /**
     * Binds {@code (t, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, char ch) {
        return ObjCharToShort.bind(this, t, ch);
    }
}
