package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, int) -> short}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjIntToShort<T> extends
        net.mintern.functions.binary.checked.ObjIntToShortE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjIntToShort<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjIntToShortE<T, E> f) {
        return (t, i) -> {
            try {
                return f.call(t, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjIntToShort<T> unchecked(
            net.mintern.functions.binary.checked.ObjIntToShortE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjIntToShort<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjIntToShortE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(t, i)} and returns the result.
     */
    static <T> net.mintern.functions.unary.IntToShort
    bind(ObjIntToShort<T> f, T t) {
        return (i) -> f.call(t, i);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(t, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(T t) {
        return ObjIntToShort.bind(this, t);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, i)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjIntToShort<T> f, int i) {
        return (t) -> f.call(t, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(int i) {
        return ObjIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (t, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, i)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToShort
    bind(ObjIntToShort<T> f, T t, int i) {
        return () -> f.call(t, i);
    }

    /**
     * Binds {@code (t, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, int i) {
        return ObjIntToShort.bind(this, t, i);
    }
}
