package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, U) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <U> the type of argument 2
 */
@FunctionalInterface
public interface ObjObjToShort<T, U> extends
        net.mintern.functions.binary.checked.ObjObjToShortE<T, U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, U, E extends Exception> ObjObjToShort<T, U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjObjToShortE<T, U, E> f) {
        return (t, u) -> {
            try {
                return f.call(t, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, U, E extends Exception> ObjObjToShort<T, U> unchecked(
            net.mintern.functions.binary.checked.ObjObjToShortE<T, U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, U, E extends java.io.IOException> ObjObjToShort<T, U> uncheckedIO(
            net.mintern.functions.binary.checked.ObjObjToShortE<T, U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(t, u)} and returns the result.
     */
    static <T, U> net.mintern.functions.unary.ObjToShort<U>
    bind(ObjObjToShort<T, U> f, T t) {
        return (u) -> f.call(t, u);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(t, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(T t) {
        return ObjObjToShort.bind(this, t);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, u)} and returns the result.
     */
    static <T, U> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjObjToShort<T, U> f, U u) {
        return (t) -> f.call(t, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(U u) {
        return ObjObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (t, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param f the unbound function
     * @param t argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, u)} and returns the result.
     */
    static <T, U> net.mintern.functions.nullary.NilToShort
    bind(ObjObjToShort<T, U> f, T t, U u) {
        return () -> f.call(t, u);
    }

    /**
     * Binds {@code (t, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, U u) {
        return ObjObjToShort.bind(this, t, u);
    }
}
