package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, short) -> R}.
 *
 * @param <T> the type of argument 1
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ObjShortToObj<T, R> extends
        net.mintern.functions.binary.checked.ObjShortToObjE<T, R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjShortToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, R, E extends Exception> ObjShortToObj<T, R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjShortToObjE<T, R, E> f) {
        return (t, sh) -> {
            try {
                return f.call(t, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, R, E extends Exception> ObjShortToObj<T, R> unchecked(
            net.mintern.functions.binary.checked.ObjShortToObjE<T, R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, R, E extends java.io.IOException> ObjShortToObj<T, R> uncheckedIO(
            net.mintern.functions.binary.checked.ObjShortToObjE<T, R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, R> net.mintern.functions.unary.ShortToObj<R>
    bind(ObjShortToObj<T, R> f, T t) {
        return (sh) -> f.call(t, sh);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param t argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> bind(T t) {
        return ObjShortToObj.bind(this, t);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (T t) -> R} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, R> net.mintern.functions.unary.ObjToObj<T, R>
    rbind(ObjShortToObj<T, R> f, short sh) {
        return (t) -> f.call(t, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (T t) -> R} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToObj<T, R> rbind(short sh) {
        return ObjShortToObj.rbind(this, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, R> net.mintern.functions.nullary.NilToObj<R>
    bind(ObjShortToObj<T, R> f, T t, short sh) {
        return () -> f.call(t, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(T t, short sh) {
        return ObjShortToObj.bind(this, t, sh);
    }
}
