package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, boolean) -> float}.
 *
 */
@FunctionalInterface
public interface ShortBoolToFloat extends
        net.mintern.functions.binary.checked.ShortBoolToFloatE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortBoolToFloatE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortBoolToFloat unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortBoolToFloatE<E> f) {
        return (sh, bool) -> {
            try {
                return f.call(sh, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortBoolToFloat unchecked(
            net.mintern.functions.binary.checked.ShortBoolToFloatE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortBoolToFloat uncheckedIO(
            net.mintern.functions.binary.checked.ShortBoolToFloatE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> float}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> float} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToFloat
    bind(ShortBoolToFloat f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> float}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> float} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToFloat bind(short sh) {
        return ShortBoolToFloat.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToFloat
    rbind(ShortBoolToFloat f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToFloat rbind(boolean bool) {
        return ShortBoolToFloat.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToFloat
    bind(ShortBoolToFloat f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToFloat bind(short sh, boolean bool) {
        return ShortBoolToFloat.bind(this, sh, bool);
    }
}
