package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, boolean) -> int}.
 *
 */
@FunctionalInterface
public interface ShortBoolToInt extends
        net.mintern.functions.binary.checked.ShortBoolToIntE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortBoolToIntE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortBoolToInt unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortBoolToIntE<E> f) {
        return (sh, bool) -> {
            try {
                return f.call(sh, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortBoolToInt unchecked(
            net.mintern.functions.binary.checked.ShortBoolToIntE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortBoolToInt uncheckedIO(
            net.mintern.functions.binary.checked.ShortBoolToIntE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> int}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> int} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToInt
    bind(ShortBoolToInt f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> int}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> int} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToInt bind(short sh) {
        return ShortBoolToInt.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToInt
    rbind(ShortBoolToInt f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToInt rbind(boolean bool) {
        return ShortBoolToInt.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToInt
    bind(ShortBoolToInt f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToInt bind(short sh, boolean bool) {
        return ShortBoolToInt.bind(this, sh, bool);
    }
}
