package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, boolean) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ShortBoolToObj<R> extends
        net.mintern.functions.binary.checked.ShortBoolToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortBoolToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> ShortBoolToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortBoolToObjE<R, E> f) {
        return (sh, bool) -> {
            try {
                return f.call(sh, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> ShortBoolToObj<R> unchecked(
            net.mintern.functions.binary.checked.ShortBoolToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> ShortBoolToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.ShortBoolToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> R} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <R> net.mintern.functions.unary.BoolToObj<R>
    bind(ShortBoolToObj<R> f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> R} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToObj<R> bind(short sh) {
        return ShortBoolToObj.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    rbind(ShortBoolToObj<R> f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> rbind(boolean bool) {
        return ShortBoolToObj.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(ShortBoolToObj<R> f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(short sh, boolean bool) {
        return ShortBoolToObj.bind(this, sh, bool);
    }
}
