package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, byte) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ShortByteToObj<R> extends
        net.mintern.functions.binary.checked.ShortByteToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortByteToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> ShortByteToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortByteToObjE<R, E> f) {
        return (sh, b) -> {
            try {
                return f.call(sh, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> ShortByteToObj<R> unchecked(
            net.mintern.functions.binary.checked.ShortByteToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> ShortByteToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.ShortByteToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> R} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ByteToObj<R>
    bind(ShortByteToObj<R> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> R} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToObj<R> bind(short sh) {
        return ShortByteToObj.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    rbind(ShortByteToObj<R> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> rbind(byte b) {
        return ShortByteToObj.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(ShortByteToObj<R> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(short sh, byte b) {
        return ShortByteToObj.bind(this, sh, b);
    }
}
