package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, float) -> char}.
 *
 */
@FunctionalInterface
public interface ShortFloatToChar extends
        net.mintern.functions.binary.checked.ShortFloatToCharE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortFloatToCharE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortFloatToChar unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortFloatToCharE<E> f) {
        return (sh, fl) -> {
            try {
                return f.call(sh, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortFloatToChar unchecked(
            net.mintern.functions.binary.checked.ShortFloatToCharE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortFloatToChar uncheckedIO(
            net.mintern.functions.binary.checked.ShortFloatToCharE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> char}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> char} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToChar
    bind(ShortFloatToChar f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> char} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToChar bind(short sh) {
        return ShortFloatToChar.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToChar
    rbind(ShortFloatToChar f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToChar rbind(float fl) {
        return ShortFloatToChar.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToChar
    bind(ShortFloatToChar f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToChar bind(short sh, float fl) {
        return ShortFloatToChar.bind(this, sh, fl);
    }
}
