package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, int) -> byte}.
 *
 */
@FunctionalInterface
public interface ShortIntToByte extends
        net.mintern.functions.binary.checked.ShortIntToByteE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortIntToByteE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortIntToByte unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortIntToByteE<E> f) {
        return (sh, i) -> {
            try {
                return f.call(sh, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortIntToByte unchecked(
            net.mintern.functions.binary.checked.ShortIntToByteE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortIntToByte uncheckedIO(
            net.mintern.functions.binary.checked.ShortIntToByteE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> byte}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> byte} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToByte
    bind(ShortIntToByte f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> byte} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToByte bind(short sh) {
        return ShortIntToByte.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToByte
    rbind(ShortIntToByte f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToByte rbind(int i) {
        return ShortIntToByte.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToByte
    bind(ShortIntToByte f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToByte bind(short sh, int i) {
        return ShortIntToByte.bind(this, sh, i);
    }
}
