package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, int) -> char}.
 *
 */
@FunctionalInterface
public interface ShortIntToChar extends
        net.mintern.functions.binary.checked.ShortIntToCharE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortIntToCharE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortIntToChar unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortIntToCharE<E> f) {
        return (sh, i) -> {
            try {
                return f.call(sh, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortIntToChar unchecked(
            net.mintern.functions.binary.checked.ShortIntToCharE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortIntToChar uncheckedIO(
            net.mintern.functions.binary.checked.ShortIntToCharE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> char}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> char} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToChar
    bind(ShortIntToChar f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> char} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToChar bind(short sh) {
        return ShortIntToChar.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToChar
    rbind(ShortIntToChar f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToChar rbind(int i) {
        return ShortIntToChar.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToChar
    bind(ShortIntToChar f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToChar bind(short sh, int i) {
        return ShortIntToChar.bind(this, sh, i);
    }
}
