package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, int) -> short}.
 *
 */
@FunctionalInterface
public interface ShortIntToShort extends
        net.mintern.functions.binary.checked.ShortIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortIntToShortE<E> f) {
        return (sh, i) -> {
            try {
                return f.call(sh, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortIntToShort unchecked(
            net.mintern.functions.binary.checked.ShortIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.ShortIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(ShortIntToShort f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(short sh) {
        return ShortIntToShort.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToShort
    rbind(ShortIntToShort f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToShort rbind(int i) {
        return ShortIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ShortIntToShort f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(short sh, int i) {
        return ShortIntToShort.bind(this, sh, i);
    }
}
