package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, long) -> short}.
 *
 */
@FunctionalInterface
public interface ShortLongToShort extends
        net.mintern.functions.binary.checked.ShortLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortLongToShortE<E> f) {
        return (sh, l) -> {
            try {
                return f.call(sh, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortLongToShort unchecked(
            net.mintern.functions.binary.checked.ShortLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.ShortLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(ShortLongToShort f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(short sh) {
        return ShortLongToShort.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToShort
    rbind(ShortLongToShort f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToShort rbind(long l) {
        return ShortLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ShortLongToShort f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(short sh, long l) {
        return ShortLongToShort.bind(this, sh, l);
    }
}
