package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, U) -> char}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface ShortObjToChar<U> extends
        net.mintern.functions.binary.checked.ShortObjToCharE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortObjToCharE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> ShortObjToChar<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortObjToCharE<U, E> f) {
        return (sh, u) -> {
            try {
                return f.call(sh, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> ShortObjToChar<U> unchecked(
            net.mintern.functions.binary.checked.ShortObjToCharE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> ShortObjToChar<U> uncheckedIO(
            net.mintern.functions.binary.checked.ShortObjToCharE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> char}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> char} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToChar<U>
    bind(ShortObjToChar<U> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> char} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToChar<U> bind(short sh) {
        return ShortObjToChar.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ShortToChar
    rbind(ShortObjToChar<U> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToChar rbind(U u) {
        return ShortObjToChar.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToChar
    bind(ShortObjToChar<U> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToChar bind(short sh, U u) {
        return ShortObjToChar.bind(this, sh, u);
    }
}
