package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, U) -> float}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface ShortObjToFloat<U> extends
        net.mintern.functions.binary.checked.ShortObjToFloatE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortObjToFloatE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> ShortObjToFloat<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortObjToFloatE<U, E> f) {
        return (sh, u) -> {
            try {
                return f.call(sh, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> ShortObjToFloat<U> unchecked(
            net.mintern.functions.binary.checked.ShortObjToFloatE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> ShortObjToFloat<U> uncheckedIO(
            net.mintern.functions.binary.checked.ShortObjToFloatE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> float}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> float} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToFloat<U>
    bind(ShortObjToFloat<U> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> float}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> float} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToFloat<U> bind(short sh) {
        return ShortObjToFloat.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ShortToFloat
    rbind(ShortObjToFloat<U> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToFloat rbind(U u) {
        return ShortObjToFloat.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToFloat
    bind(ShortObjToFloat<U> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToFloat bind(short sh, U u) {
        return ShortObjToFloat.bind(this, sh, u);
    }
}
