package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, U) -> R}.
 *
 * @param <U> the type of argument 2
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ShortObjToObj<U, R> extends
        net.mintern.functions.binary.checked.ShortObjToObjE<U, R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortObjToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, R, E extends Exception> ShortObjToObj<U, R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortObjToObjE<U, R, E> f) {
        return (sh, u) -> {
            try {
                return f.call(sh, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, R, E extends Exception> ShortObjToObj<U, R> unchecked(
            net.mintern.functions.binary.checked.ShortObjToObjE<U, R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, R, E extends java.io.IOException> ShortObjToObj<U, R> uncheckedIO(
            net.mintern.functions.binary.checked.ShortObjToObjE<U, R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> R}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> R} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, R> net.mintern.functions.unary.ObjToObj<U, R>
    bind(ShortObjToObj<U, R> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> R} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToObj<U, R> bind(short sh) {
        return ShortObjToObj.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, R> net.mintern.functions.unary.ShortToObj<R>
    rbind(ShortObjToObj<U, R> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> rbind(U u) {
        return ShortObjToObj.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <U> the type of argument 2
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, R> net.mintern.functions.nullary.NilToObj<R>
    bind(ShortObjToObj<U, R> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(short sh, U u) {
        return ShortObjToObj.bind(this, sh, u);
    }
}
