package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, short) -> long}.
 *
 */
@FunctionalInterface
public interface ShortShortToLong extends
        net.mintern.functions.binary.checked.ShortShortToLongE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortShortToLongE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortShortToLong unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortShortToLongE<E> f) {
        return (sh1, sh2) -> {
            try {
                return f.call(sh1, sh2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortShortToLong unchecked(
            net.mintern.functions.binary.checked.ShortShortToLongE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortShortToLong uncheckedIO(
            net.mintern.functions.binary.checked.ShortShortToLongE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> long} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToLong
    bind(ShortShortToLong f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> long} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToLong bind(short sh1) {
        return ShortShortToLong.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> long} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToLong
    rbind(ShortShortToLong f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> long} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToLong rbind(short sh2) {
        return ShortShortToLong.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToLong
    bind(ShortShortToLong f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToLong bind(short sh1, short sh2) {
        return ShortShortToLong.bind(this, sh1, sh2);
    }
}
