package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, short) -> void}.
 *
 */
@FunctionalInterface
public interface ShortShortToNil extends
        net.mintern.functions.binary.checked.ShortShortToNilE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortShortToNilE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortShortToNil unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortShortToNilE<E> f) {
        return (sh1, sh2) -> {
            try {
                f.call(sh1, sh2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortShortToNil unchecked(
            net.mintern.functions.binary.checked.ShortShortToNilE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortShortToNil uncheckedIO(
            net.mintern.functions.binary.checked.ShortShortToNilE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> void} that calls
     *      {@code f.call(sh1, sh2)}.
     */
    static  net.mintern.functions.unary.ShortToNil
    bind(ShortShortToNil f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> void} that calls
     *      {@code this.call(sh1, sh2)}.
     */
    @Override
    default net.mintern.functions.unary.ShortToNil bind(short sh1) {
        return ShortShortToNil.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> void} that calls
     *      {@code f.call(sh1, sh2)}.
     */
    static  net.mintern.functions.unary.ShortToNil
    rbind(ShortShortToNil f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> void} that calls
     *      {@code this.call(sh1, sh2)}.
     */
    @Override
    default net.mintern.functions.unary.ShortToNil rbind(short sh2) {
        return ShortShortToNil.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh1, sh2)}.
     */
    static  net.mintern.functions.nullary.NilToNil
    bind(ShortShortToNil f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh1, sh2)}.
     */
    @Override
    default net.mintern.functions.nullary.NilToNil bind(short sh1, short sh2) {
        return ShortShortToNil.bind(this, sh1, sh2);
    }
}
