package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, short) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ShortShortToObj<R> extends
        net.mintern.functions.binary.checked.ShortShortToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortShortToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> ShortShortToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortShortToObjE<R, E> f) {
        return (sh1, sh2) -> {
            try {
                return f.call(sh1, sh2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> ShortShortToObj<R> unchecked(
            net.mintern.functions.binary.checked.ShortShortToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> ShortShortToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.ShortShortToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> R} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    bind(ShortShortToObj<R> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> R} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> bind(short sh1) {
        return ShortShortToObj.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> R} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    rbind(ShortShortToObj<R> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> R} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> rbind(short sh2) {
        return ShortShortToObj.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(ShortShortToObj<R> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(short sh1, short sh2) {
        return ShortShortToObj.bind(this, sh1, sh2);
    }
}
