package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool1 argument 1
     * @param bool2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool1, boolean bool2) throws E;

    /**
     * Binds {@code (bool1)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool1 argument 1
     * @return a new function {@code (boolean bool2) -> short} that calls
     *      {@code f.call(bool1, bool2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(BoolBoolToShortE<E> f, boolean bool1) {
        return (bool2) -> f.call(bool1, bool2);
    }

    /**
     * Binds {@code (bool1)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param bool1 argument 1
     * @return a new function {@code (boolean bool2) -> short} that calls
     *      {@code this.call(bool1, bool2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(boolean bool1) {
        return BoolBoolToShortE.bind(this, bool1);
    }

    /**
     * Binds {@code (bool2)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool2 argument 2
     * @return a new function {@code (boolean bool1) -> short} that calls
     *      {@code f.call(bool1, bool2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolBoolToShortE<E> f, boolean bool2) {
        return (bool1) -> f.call(bool1, bool2);
    }

    /**
     * Binds {@code (bool2)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param bool2 argument 2
     * @return a new function {@code (boolean bool1) -> short} that calls
     *      {@code this.call(bool1, bool2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(boolean bool2) {
        return BoolBoolToShortE.rbind(this, bool2);
    }

    /**
     * Binds {@code (bool1, bool2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool1 argument 1
     * @param bool2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool1, bool2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolBoolToShortE<E> f, boolean bool1, boolean bool2) {
        return () -> f.call(bool1, bool2);
    }

    /**
     * Binds {@code (bool1, bool2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool1 argument 1
     * @param bool2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool1, bool2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool1, boolean bool2) {
        return BoolBoolToShortE.bind(this, bool1, bool2);
    }
}
