package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, char ch) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(bool, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(BoolCharToShortE<E> f, boolean bool) {
        return (ch) -> f.call(bool, ch);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(bool, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(boolean bool) {
        return BoolCharToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolCharToShortE<E> f, char ch) {
        return (bool) -> f.call(bool, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(char ch) {
        return BoolCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (bool, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolCharToShortE<E> f, boolean bool, char ch) {
        return () -> f.call(bool, ch);
    }

    /**
     * Binds {@code (bool, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, char ch) {
        return BoolCharToShortE.bind(this, bool, ch);
    }
}
