package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, double d) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(bool, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(BoolDblToShortE<E> f, boolean bool) {
        return (d) -> f.call(bool, d);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(bool, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(boolean bool) {
        return BoolDblToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolDblToShortE<E> f, double d) {
        return (bool) -> f.call(bool, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(double d) {
        return BoolDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (bool, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolDblToShortE<E> f, boolean bool, double d) {
        return () -> f.call(bool, d);
    }

    /**
     * Binds {@code (bool, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, double d) {
        return BoolDblToShortE.bind(this, bool, d);
    }
}
