package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, int i) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(bool, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(BoolIntToShortE<E> f, boolean bool) {
        return (i) -> f.call(bool, i);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(bool, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(boolean bool) {
        return BoolIntToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolIntToShortE<E> f, int i) {
        return (bool) -> f.call(bool, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(int i) {
        return BoolIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (bool, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolIntToShortE<E> f, boolean bool, int i) {
        return () -> f.call(bool, i);
    }

    /**
     * Binds {@code (bool, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, int i) {
        return BoolIntToShortE.bind(this, bool, i);
    }
}
