package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, U u) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(bool, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(BoolObjToShortE<U, E> f, boolean bool) {
        return (u) -> f.call(bool, u);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(bool, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(boolean bool) {
        return BoolObjToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolObjToShortE<U, E> f, U u) {
        return (bool) -> f.call(bool, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(U u) {
        return BoolObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (bool, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolObjToShortE<U, E> f, boolean bool, U u) {
        return () -> f.call(bool, u);
    }

    /**
     * Binds {@code (bool, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, U u) {
        return BoolObjToShortE.bind(this, bool, u);
    }
}
