package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, short) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolShortToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(boolean bool, short sh) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    bind(BoolShortToByteE<E> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> bind(boolean bool) {
        return BoolShortToByteE.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> byte} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToByteE<E>
    rbind(BoolShortToByteE<E> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> byte}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> byte} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToByteE<E> rbind(short sh) {
        return BoolShortToByteE.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(BoolShortToByteE<E> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(boolean bool, short sh) {
        return BoolShortToByteE.bind(this, bool, sh);
    }
}
