package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, short) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolShortToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(boolean bool, short sh) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    bind(BoolShortToCharE<E> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> bind(boolean bool) {
        return BoolShortToCharE.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> char} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToCharE<E>
    rbind(BoolShortToCharE<E> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> char} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToCharE<E> rbind(short sh) {
        return BoolShortToCharE.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(BoolShortToCharE<E> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(boolean bool, short sh) {
        return BoolShortToCharE.bind(this, bool, sh);
    }
}
