package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, byte) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteByteToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b1 argument 1
     * @param b2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b1, byte b2) throws E;

    /**
     * Binds {@code (b1)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b1 argument 1
     * @return a new function {@code (byte b2) -> short} that calls
     *      {@code f.call(b1, b2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(ByteByteToShortE<E> f, byte b1) {
        return (b2) -> f.call(b1, b2);
    }

    /**
     * Binds {@code (b1)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param b1 argument 1
     * @return a new function {@code (byte b2) -> short} that calls
     *      {@code this.call(b1, b2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(byte b1) {
        return ByteByteToShortE.bind(this, b1);
    }

    /**
     * Binds {@code (b2)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b2 argument 2
     * @return a new function {@code (byte b1) -> short} that calls
     *      {@code f.call(b1, b2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteByteToShortE<E> f, byte b2) {
        return (b1) -> f.call(b1, b2);
    }

    /**
     * Binds {@code (b2)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param b2 argument 2
     * @return a new function {@code (byte b1) -> short} that calls
     *      {@code this.call(b1, b2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(byte b2) {
        return ByteByteToShortE.rbind(this, b2);
    }

    /**
     * Binds {@code (b1, b2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b1 argument 1
     * @param b2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b1, b2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteByteToShortE<E> f, byte b1, byte b2) {
        return () -> f.call(b1, b2);
    }

    /**
     * Binds {@code (b1, b2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b1 argument 1
     * @param b2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b1, b2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b1, byte b2) {
        return ByteByteToShortE.bind(this, b1, b2);
    }
}
