package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, char ch) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(b, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(ByteCharToShortE<E> f, byte b) {
        return (ch) -> f.call(b, ch);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(b, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(byte b) {
        return ByteCharToShortE.bind(this, b);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteCharToShortE<E> f, char ch) {
        return (b) -> f.call(b, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(char ch) {
        return ByteCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (b, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteCharToShortE<E> f, byte b, char ch) {
        return () -> f.call(b, ch);
    }

    /**
     * Binds {@code (b, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, char ch) {
        return ByteCharToShortE.bind(this, b, ch);
    }
}
