package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, int i) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(b, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(ByteIntToShortE<E> f, byte b) {
        return (i) -> f.call(b, i);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(b, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(byte b) {
        return ByteIntToShortE.bind(this, b);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteIntToShortE<E> f, int i) {
        return (b) -> f.call(b, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(int i) {
        return ByteIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (b, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteIntToShortE<E> f, byte b, int i) {
        return () -> f.call(b, i);
    }

    /**
     * Binds {@code (b, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, int i) {
        return ByteIntToShortE.bind(this, b, i);
    }
}
