package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, long l) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(b, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(ByteLongToShortE<E> f, byte b) {
        return (l) -> f.call(b, l);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(b, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(byte b) {
        return ByteLongToShortE.bind(this, b);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteLongToShortE<E> f, long l) {
        return (b) -> f.call(b, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(long l) {
        return ByteLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (b, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteLongToShortE<E> f, byte b, long l) {
        return () -> f.call(b, l);
    }

    /**
     * Binds {@code (b, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, long l) {
        return ByteLongToShortE.bind(this, b, l);
    }
}
