package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, U u) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(b, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(ByteObjToShortE<U, E> f, byte b) {
        return (u) -> f.call(b, u);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(b, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(byte b) {
        return ByteObjToShortE.bind(this, b);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteObjToShortE<U, E> f, U u) {
        return (b) -> f.call(b, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(U u) {
        return ByteObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (b, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteObjToShortE<U, E> f, byte b, U u) {
        return () -> f.call(b, u);
    }

    /**
     * Binds {@code (b, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, U u) {
        return ByteObjToShortE.bind(this, b, u);
    }
}
