package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, short) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteShortToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(byte b, short sh) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    bind(ByteShortToByteE<E> f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> bind(byte b) {
        return ByteShortToByteE.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToByteE<E>
    rbind(ByteShortToByteE<E> f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToByteE<E> rbind(short sh) {
        return ByteShortToByteE.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ByteShortToByteE<E> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(byte b, short sh) {
        return ByteShortToByteE.bind(this, b, sh);
    }
}
